/*
LodePNG Examples

Copyright (c) 2005-2012 Lode Vandevenne

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you must not
    claim that you wrote the original software. If you use this software
    in a product, an acknowledgment in the product documentation would be
    appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and must not be
    misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
    distribution.
*/

#include "lodepng.h"

#include <stdio.h>
#include <stdlib.h>
#include "loadNameTable.h"
#include "example_decode.h"
#define RED_TWO_START 0x00000
#define RED_ONE_START 0x02000
#define RED_ZERO_START 0x04000
#define GREEN_TWO_START 0x08000
#define GREEN_ONE_START 0x06000
#define GREEN_ZERO_START 0x0A000
#define BLUE_TWO_START 0x0C000
#define BLUE_ONE_START 0x0E000
#define BLUE_ZERO_START 0x10000

//void writeSegmentPattern(unsigned int address, unsigned int data);
//void set32BitPattern(unsigned int patternIndex , const char* filename);

/*void writeSegmentPattern(unsigned int address, unsigned int data){
  //printf("Address: %ld\n", address); 
  //printf("Data: %ld\n", data); 
  printf("master_write_32 $m %d 0x%.8X\n", address, data);
}*/

void set32BitPattern(unsigned int patternIndex , const char* filename)
{
  unsigned error;
  unsigned char* image;
  unsigned width, height;
  char redPNGLineBuff[32];
  char greenPNGLineBuff[32];
  char bluePNGLineBuff[32];
  int x,y,pixelIndex;

  unsigned int baseOffset;
  unsigned int redChanTwoData;
  unsigned int redChanOneData;
  unsigned int redChanZeroData;
  unsigned int greenChanTwoData;
  unsigned int greenChanOneData;
  unsigned int greenChanZeroData;
  unsigned int blueChanTwoData;
  unsigned int blueChanOneData;
  unsigned int blueChanZeroData;

  unsigned int redPixTwo;
  unsigned int redPixOne;
  unsigned int redPixZero;
  unsigned int greenPixTwo;
  unsigned int greenPixOne;
  unsigned int greenPixZero;
  unsigned int bluePixTwo;
  unsigned int bluePixOne;
  unsigned int bluePixZero;

  baseOffset = patternIndex * 32;

  error = lodepng_decode24_file(&image, &width, &height, filename);
  if(error) printf("error %u: %s\n", error, lodepng_error_text(error));

  for(y = 0; y < 32; y++){
    for(x = 0; x < 32; x++){
      redPNGLineBuff[x]   = image[96*y + x*3] / 32;        // Scale data to 3 bits
      greenPNGLineBuff[x] = image[96*y + x*3 + 1] / 32;
      bluePNGLineBuff[x]  = image[96*y + x*3 + 2] / 32;
    }

    redChanTwoData = 0;
    redChanOneData = 0;
    redChanZeroData = 0;
    greenChanTwoData = 0;
    greenChanOneData = 0;
    greenChanZeroData = 0;
    blueChanTwoData = 0;
    blueChanOneData = 0;
    blueChanZeroData = 0;

    for(pixelIndex = 0; pixelIndex < 32; pixelIndex++){
      // Extract 9 bits of compressed color 
      redPixTwo    = (redPNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
      redPixOne    = (redPNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
      redPixZero   = (redPNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;
      greenPixTwo  = (greenPNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
      greenPixOne  = (greenPNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
      greenPixZero = (greenPNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;
      bluePixTwo   = (bluePNGLineBuff[pixelIndex] & 0x04) != 0 ? 1 : 0;
      bluePixOne   = (bluePNGLineBuff[pixelIndex] & 0x02) != 0 ? 1 : 0;
      bluePixZero  = (bluePNGLineBuff[pixelIndex] & 0x01) != 0 ? 1 : 0;

      // Red 3 bit color channel
      redChanTwoData = redChanTwoData + (redPixTwo << (pixelIndex));
      redChanOneData = redChanOneData + (redPixOne << (pixelIndex));
      redChanZeroData = redChanZeroData + (redPixZero << (pixelIndex));
      // Green 3 bit color channel
      greenChanTwoData = greenChanTwoData + (greenPixTwo << (pixelIndex));
      greenChanOneData = greenChanOneData + (greenPixOne << (pixelIndex));
      greenChanZeroData = greenChanZeroData + (greenPixZero << (pixelIndex));
      // Blue 3 bit color channel
      blueChanTwoData = blueChanTwoData + (bluePixTwo << (pixelIndex));
      blueChanOneData = blueChanOneData + (bluePixOne << (pixelIndex));
      blueChanZeroData = blueChanZeroData + (bluePixZero << (pixelIndex));

      // Write color channels to fpga

      //printf("*****************Line number: %d *******************\n", y);
      //printf("Red Channels\n");
      writeSegmentPattern(4*(RED_TWO_START  + baseOffset + y), redChanTwoData);
      writeSegmentPattern(4*(RED_ONE_START  + baseOffset + y), redChanOneData);
      writeSegmentPattern(4*(RED_ZERO_START + baseOffset + y), redChanZeroData);
      //printf("Green Channels\n");
      writeSegmentPattern(4*(GREEN_TWO_START  + baseOffset + y), greenChanTwoData);
      writeSegmentPattern(4*(GREEN_ONE_START  + baseOffset + y), greenChanOneData);
      writeSegmentPattern(4*(GREEN_ZERO_START + baseOffset + y), greenChanZeroData);
      //printf("Blue Channels\n");
      writeSegmentPattern(4*(BLUE_TWO_START + baseOffset + y), blueChanTwoData);
      writeSegmentPattern(4*(BLUE_ONE_START  + baseOffset + y), blueChanOneData);
      writeSegmentPattern(4*(BLUE_ZERO_START + baseOffset + y), blueChanZeroData);
    }
  }
    
  free(image); 
  
}


/*int main(int argc, char *argv[])
{
  const char* filename = argc > 1 ? argv[1] : "test.png";

  set32BitPattern(0, filename);

  return 0;
}*/

